function [tabulated_clutch_forces, tabulated_clutch_free_energies] = tabulate_clutch_force_and_energy(substrate_stiffness, N_unfolding_domains, clutch_extension, linker_size, domain_contour_length, clutch_delta_G_0, list_of_clutch_states, kT, L_p, talin_globular_domain_number, integrin_globular_domain_number, globular_domain_size) 

% this program tabulates extension-force curves of different clutch states
% as well as extension-free energy curves

tabulated_clutch_forces = zeros( 2^N_unfolding_domains, size(clutch_extension, 2) );
clutch_delta_G_0_column = zeros( 2^N_unfolding_domains, 1 );

for i = 1 : 2^N_unfolding_domains
%     tabulated_clutch_forces(i, :) = force_vs_extension_clutch_v2(substrate_stiffness, clutch_extension, list_of_clutch_states(i, :), N_unfolding_domains, linker_size, domain_contour_length, kT, L_p, talin_globular_domain_number, integrin_globular_domain_number, globular_domain_size);
    temp_force = force_vs_extension_clutch_v2(substrate_stiffness, clutch_extension, list_of_clutch_states(i, :), N_unfolding_domains, linker_size, domain_contour_length, kT, L_p, talin_globular_domain_number, integrin_globular_domain_number, globular_domain_size);
    tabulated_clutch_forces(i, :) = csaps(clutch_extension, temp_force, 0.1, clutch_extension);
    index_100 = find(tabulated_clutch_forces(i, :)  > 100, 1);
    tabulated_clutch_forces(i, index_100:end) = 100;
    clutch_delta_G_0_column(i) = sum( list_of_clutch_states(i, :) .* clutch_delta_G_0, 'all' ); % state = 0 - folded (5nm domain), 1 - unfolded (wlc)
end

% tabulated_clutch_forces( tabulated_clutch_forces > 100 ) = 100;

extension_step = clutch_extension(2) - clutch_extension(1);
talin_delta_G_0_array = repmat( clutch_delta_G_0_column, 1, size(clutch_extension, 2) );
tabulated_clutch_free_energies = cumsum(tabulated_clutch_forces, 2) * extension_step;
tabulated_clutch_free_energies = tabulated_clutch_free_energies + talin_delta_G_0_array;

end

